
$(document).ready(function () {
    $(".modal").each(function () {
        $(this).modal({
            backdrop: "static",
            keyboard: false
        });
    });

    toastr.options = {
        "closeButton": true,
        "debug": false,
        "newestOnTop": false,
        "progressBar": true,
        "positionClass": "toast-middle-right",
        "preventDuplicates": true,
        "onclick": null,
        "showDuration": "300",
        "hideDuration": "1000",
        "timeOut": "5000",
        "extendedTimeOut": "1000",
        "showEasing": "swing",
        "hideEasing": "linear",
        "showMethod": "fadeIn",
        "hideMethod": "fadeOut"
    }
});


function showSweetAlert(message = null, type, route = null) {

}


function showAlertQuestion(message, type, route = null) {
    Swal.fire({
        text: message,
        icon: type,
        showCancelButton: true,
        confirmButtonColor: "#3461FF",
        cancelButtonColor: "#212529",
        confirmButtonText: "Adicionar serviços",
        cancelButtonText: "Adicionar depois",
        allowOutsideClick: false,
        allowEscapeKey: false,
    }).then((result) => {
        if (result.isConfirmed && route) {
            window.location.href = route;
        }
    });
}

function initSelect2(element) {
    $(element).select2({
        theme: 'bootstrap4',
        width: $(element).data('width') || ($(element).hasClass('w-100') ? '100%' : 'style'),
        placeholder: $(element).data('placeholder') || 'Selecione uma opção',
        allowClear: $(element).data('allow-clear') === true
    });
}
function initCustomDataTable(tableSelector, filterConfig = null) {
    const $table = $(tableSelector);

    const dt = $table.DataTable({
        language: {
            "zeroRecords": "Nenhum resultado encontrado",
            "info": "Mostrando _START_ a _END_ de _TOTAL_ registros",
            "infoEmpty": "Mostrando 0 a 0 de 0 registros",
            "infoFiltered": "(filtrado de _MAX_ no total)",
            "search": "Pesquisar:",
            "paginate": {
                "previous": "‹",
                "next": "›"
            }
        },
        dom: '<"top-filtro d-flex justify-content-between align-items-center mb-0"f>rt<"bottom d-flex justify-content-between align-items-center mt-3"ip>',
    });

    if (filterConfig && filterConfig.selector && filterConfig.filterFn) {
        const $filtro = $(filterConfig.selector).closest('.mb-3');

        if ($filtro.length) {
            $('.top-filtro').prepend($filtro);
        }

        $(filterConfig.selector).on('change keyup', function () {
            const filtroValor = $(this).val().toLowerCase();
            filterConfig.filterFn(dt, $table, filtroValor);
        });
    }

    return dt;
}
function initDataTable(tableSelector, filterConfig = null) {
    const $table = $(tableSelector);

    // Se já foi inicializado, destrói antes
    if ($.fn.DataTable.isDataTable($table)) {
        $table.DataTable().clear().destroy();
    }

    const dt = $table.DataTable({
        pageLength: 30,
        lengthChange: false,
        language: {
            "zeroRecords": "Nenhum resultado encontrado",
            "info": "Mostrando _START_ a _END_ de _TOTAL_ registros",
            "infoEmpty": "Mostrando 0 a 0 de 0 registros",
            "infoFiltered": "(filtrado de _MAX_ no total)",
            "search": "Pesquisar:",
            "paginate": {
                "previous": "‹",
                "next": "›"
            }
        },
        initComplete: function () {
            const wrapper = $(this).closest('.dataTables_wrapper');
            const filterWrapper = wrapper.find('.dataTables_filter');
            const label = filterWrapper.find('label');
            const input = label.find('input');

            input
                .addClass('form-control form-control-sm')
                .attr('placeholder', 'Digite para filtrar...')
                .css({
                    width: '100%',
                    maxWidth: '100%',
                    minWidth: '300px',
                    borderBottom: '1px solid #015508',
                    padding: '.25rem .5rem',
                    borderRadius: '.02rem',
                    boxSizing: 'border-box'
                });

            label.contents().filter(function () {
                return this.nodeType === 3;
            }).remove();

            filterWrapper.css({
                display: 'block',
                textAlign: 'left',
                width: '100%',
                marginBottom: '1rem'
            });

            label.css({
                display: 'block',
                width: '100%'
            });
        }
    });

    return dt;
}





function initSelect2Ajax(selector = '.service-code', route) {
    let element = $(selector);

    if (!element.length) return;

    element.select2({
        placeholder: "Digite o código",
        theme: 'bootstrap4',
        width: '100%',
        allowClear: true,
        ajax: {
            url: route,
            dataType: 'json',
            delay: 250,
            data: (params) => ({ criteria: params.term }),
            processResults: (data) => {
                console.log(data);
                return {
                    results: data.dados.map(item => ({
                        id: item.id,
                        text: item.nome,
                    }))
                };
            },
            cache: true
        },
        minimumInputLength: 2
    }).on('select2:select', function (e) {
        let data = e.params.data;
        $('#moderado_por').val(data.id)
    })

    element.on('select2:open', function () {
        $('.select2-container--bootstrap4 .select2-selection').css('border-bottom', '2px solid #dc3545');
    }).on('select2:close', function () {
        $('.select2-container--bootstrap4 .select2-selection').css('border-bottom', '2px solid #5a6268');
    });
}






